#include "global.h"
#include "info_aqui.h"
#include "direct_interpreter.h"



int compute(CODE *c, DATA *data_in, DATA *scratch, DATA *data_out)
{
long i;

for(i=0;c[i];){
	switch(c[i] & (~7)){
		case OP_STOP:
				return 0;
		case OP_ADD:
			RESULT(c[i],data_in,scratch,data_out)[c[i+1]]=
				DATA1(c[i],data_in,scratch,data_out)[c[i+2]]+
				DATA2(c[i],data_in,scratch,data_out)[c[i+3]];
			i+=4;
			break;
		case OP_SUB:
			RESULT(c[i],data_in,scratch,data_out)[c[i+1]]=
				DATA1(c[i],data_in,scratch,data_out)[c[i+2]]-
				DATA2(c[i],data_in,scratch,data_out)[c[i+3]];
			i+=4;
			break;
		case OP_MUL:
			RESULT(c[i],data_in,scratch,data_out)[c[i+1]]=
				DATA1(c[i],data_in,scratch,data_out)[c[i+2]]*
				DATA2(c[i],data_in,scratch,data_out)[c[i+3]];
			i+=4;
			break;
		case OP_AND:
			RESULT(c[i],data_in,scratch,data_out)[c[i+1]]=
				DATA1(c[i],data_in,scratch,data_out)[c[i+2]] &&
				DATA2(c[i],data_in,scratch,data_out)[c[i+3]];
			i+=4;
			break;
		case OP_OR:
			RESULT(c[i],data_in,scratch,data_out)[c[i+1]]=
				DATA1(c[i],data_in,scratch,data_out)[c[i+2]]||
				DATA2(c[i],data_in,scratch,data_out)[c[i+3]];
			i+=4;
			break;
		case OP_SLESS:
			RESULT(c[i],data_in,scratch,data_out)[c[i+1]]=
				DATA1(c[i],data_in,scratch,data_out)[c[i+2]] <
				DATA2(c[i],data_in,scratch,data_out)[c[i+3]];
			i+=4;
			break;
		case OP_SGREATER:
			RESULT(c[i],data_in,scratch,data_out)[c[i+1]]=
				DATA1(c[i],data_in,scratch,data_out)[c[i+2]] >
				DATA2(c[i],data_in,scratch,data_out)[c[i+3]];
			i+=4;
			break;
		case OP_BRANCH:
			if(DATA1(c[i],data_in,scratch,data_out)[c[i+1]])
				i=c[i+2];
					else
				i=c[i+3];
			break;
		case OP_CONST:
			RESULT(c[i],data_in,scratch,data_out)[c[i+1]]=
				DATA1(c[i],data_in,scratch,data_out)[c[i+2]];
			i+=3;
			break;
		case OP_INFO_AQUI:
			RESULT(c[i],data_in,scratch,data_out)[c[i+1]]=
				get_value(DATA1(c[i],data_in,scratch,data_out)[c[i+2]]);
			i+=3;
			break;
		default:			
			return -1;
				
		}
	}

return 0;
}
